#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Lost marblesMod01.fsh by  grinist  
//https://www.shadertoy.com/view/Ml2BWR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// A dirty old 2d sphere trick that just projects a texture in 2d. Obviously this can't withstand
// closer scrutiny. Textures with distinct features give it away instantly. Also the glow can't
// represent what's underneath the marble.
// This is close to something we got away with in a game. Although we were targeting GLES1
// and did this with texture coordinates and additional tricks with the geometry.

#define PI 3.1415926536
#define HPI (PI / 2.0)
#define TAU (2.0 * PI)
#define TSCALE 1.25
#define MARBLES 9

// returns normalized distance along sphere surface given 2d radius
float surface(float d)
{
    return asin(clamp(d, 0.0, 1.0)) / HPI * TSCALE;
}

// returns normalized distance along sphere surface given 2d distance on background plane
float glow(float d, float sr)
{
    return atan(d / sr) / HPI * TSCALE;
}

struct Marble
{
    vec2 pos;
    vec2 v;
    vec2 nv;
    float d;
   	float r;
    vec2 tpos;
};

Marble m[MARBLES];

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float time = iTime * 0.28;
	vec2 uv = fragCoord.xy / iResolution.y;
    vec2 size = vec2(iResolution.x/iResolution.y, 1.0);

    // background
    vec3 color = vec3(0.025, 0.05, 0.15);

    // set up marbles and accumulate glows
    float p = 0.0;
    float pinc = TAU / float(MARBLES);
    for (int i = 0; i < MARBLES; i++)
    {
        // position and distance vecs
        vec2 off = vec2(cos(time + p), sin(time + p));
        m[i].pos = 0.5 * size + 0.33 * size * off + sin((time + p) * 6.0) * off.yx * 0.12;

        m[i].v = uv - m[i].pos;
        m[i].d = length(m[i].v);
        m[i].nv = m[i].v / m[i].d;

        // marble radius and texture position
        m[i].r = 0.1 + sin(p * 5.0) * 0.025;
        m[i].tpos = 0.5 + 0.1 * p - m[i].pos / HPI * TSCALE;

        // background glow
        float g = glow(m[i].d, m[i].r);
        vec2 guv = 0.5 + m[i].tpos - m[i].nv * g * m[i].r;
        vec3 gc = texture2D(iChannel0, guv).rbg;
        gc = smoothstep(0.5, 0.9, gc) * vec3(0.4, 0.3, 0.1);
        // attenuation
        float gd = sqrt(m[i].d * m[i].d + m[i].r * m[i].r) - m[i].r;
        gc /= (0.5 + 1000.0 * gd * gd);
        color += gc;
        
        p += pinc;
    }
    
    // draw marbles on top
    for (int i = 0; i < MARBLES; i++)
    {
        // marble surface
        float md = m[i].d / m[i].r;
        if (md > 1.0)
            continue;
        float ms = surface(md);
        vec2 muv = m[i].tpos + m[i].nv * ms * m[i].r;
        vec3 mc = texture2D(iChannel0, muv).rgb;
        // glow
        vec3 mg = smoothstep(0.55, 0.9, mc.rbg) * 0.5;
        // base falloff
        mc *= (1.0 - clamp(md * 1.1, 0.0, 0.8));
        // glow with additional falloff
        mc += mg * (1.0 - 0.5 * md);
        // rim, hides the problem at rotational poles a bit
        mc = mix(mc, vec3(0.15, 0.1, 0.2), smoothstep(0.25, 1.0, md * md) * 0.9);
        // highlight
        mc += smoothstep(0.18, 0.04, md) * vec3(0.15, 0.15, 0.2);
        // aa
        float alpha = 1.0 - smoothstep(m[i].r - 0.002, m[i].r, m[i].d);
        color = mix(color, mc, alpha);
    }
    
    fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

